* This SPSS command file takes as input an SPSS dataset of Emergency Department encounter records, and
* duplicates that dataset with additional variables that indicate the percentage of each encounter that falls
* into various categories, such as non-emergent, emergent but primary care treatable, ED care needed
* but not preventable (i.e., an Ambulatory Care Sensitive (ACS) condition), and ED care needed and preventable.

* DIRECTION FOR USE: Put the accompanying SPSS data files (FINDXACS.SAV and DX GROUPS.SAV) in the directory
* where you have your SPSS dataset of ED records, and set the four "LET" statements below to the
* appropriate values.  The output dataset will be created in the same directory as the input dataset.

define !edapp ().

* Set to the full directory path, with quotation marks and a terminating backslash, where data files are and output will be written.
!let !Path='c:\ED Data\New York City\'.
* Set to the name of the SPSS dataset, with quotation marks and the .SAV extension, that contains your ED records.
!let !Dataset='ed01.sav'.
* Set to the name of the field that contains Principal Diagnosis.
!let !DxVar=icd9.
* Set to the name, including the .sav extension, you want for the output dataset.
!let !out='edout01.sav'.

get file = !quote(!concat(!path,!dataset)).
compute !dxvar = ltrim(upcase(!dxvar)).
sort cases by !dxvar.
match files file=* /table=!quote(!concat(!path,'dx groups.sav')) /rename=(dx=!dxvar) /by !dxvar.

do if (dxgroup eq '').
do if (any(substr(!dxvar,1,4),'2501','2780','4151','5301','5751','6860','7807','7890','9898','9955','9970')).
compute dxgroup=substr(!dxvar,1,4).
else if (any(substr(!dxvar,1,3),'042','493','682','850','V72') or any(substr(!dxvar,1,4),'8540','8541')).
compute dxgroup=substr(!dxvar,1,3).
else if (any(substr(!dxvar,1,3),'043','044')).
compute dxgroup='042'.
else if (substr(!dxvar,1,3)='789' and not any(!dxvar,'7891','7893','78930')).
compute dxgroup='7890'.
else if (substr(!dxvar,1,4)='7865' and not any(!dxvar,'78651','78652','78659')).
compute dxgroup='78650'.
else.
compute dxgroup=!dxvar.
end if.
end if.

sort cases by dxgroup.
match files file=* /table=!quote(!concat(!path,'Eddxs.sav')) /rename=(prindx=dxgroup) /in=findxacs /by dxgroup.

compute injury=any(substr(dxgroup,1,1),'8','9')
 or substr(dxgroup,1,2)='E8'
 or any(substr(dxgroup,1,3),'E90','E91','E92','E93','E94','E96','E97','E98').

compute psych=any(substr(dxgroup,1,3),'290','293','294','295','296','297','298','299','300',
                  '301','302','306','307','308','309','310','311','312','313','314','315','316','317','318','319','E95')
 or any(substr(dxgroup,1,4),'6484','V110','V111','V112','V114','V115','V116','V117','V118','V119','V710','V790').

compute drugalc=any(substr(dxgroup,1,3),'291','303','292','304')
 or any(substr(dxgroup,1,4),'3050','3575','4255','5353','5710','5712','5713','7903',
 'V704','V113','V791','3052','3053','3054','3055','3056','3057','3058','3059','3576','6483','6555','7795')
 or any(dxgroup,'76071','76072','76073','76075').

compute acs=any(substr(dxgroup,1,3),'033','390','391','037','045','345','481','483',
 '485','486','462','463','465','011','012','013','014','015','016','017','018','491','492','493',
 '494','496','681','682','683','686','590','260','261','262','521','522','523','525','528','382',
 '428','413','614')
 or any(substr(dxgroup,1,4),'7803','4721','2500','2501','2502','2503','2508','2509',
 '2512','5589','5590','5599','2765','2680','2681','4660','4822','4823','4829','5184',
 '4010','4019','4111','4118','3200','2801','2808','2809','7834','7070','7071','7078','7079')
 or any(dxgroup,'40201','40211','40291','40210','40290','40200').

do if (injury or psych or drugalc).
compute unclass=0.
compute nemrg=0.
compute epct=0.
compute edcnpa=0.
compute edcnnpa=0.
else if (findxacs).
compute unclass=0.
compute nemrg=sum(0,nonemerg).
compute epct=sum(0,emergpc).
do if (acs).
compute edcnpa=sum(0,emedpa,emednpa).
compute edcnnpa=0.
else.
compute edcnpa=0.
compute edcnnpa=sum(0,emedpa,emednpa).
end if.
else.
compute unclass=1.
compute nemrg=0.
compute epct=0.
compute edcnpa=0.
compute edcnnpa=0.
end if.

save outfile=!quote(!concat(!path,!out)) /drop=emednpa emedpa emergpc nonemerg acs.
get file = !quote(!concat(!path,!out)).

!enddefine.
set mexpand on.
set mprint on.
!edapp.

* NOTES: This version includes the 6/5/03 "fix" of icd9 codes beginning 789 and 7865, requested by John.
* As of 6/9/03, this fix is in this version and the access version.